const protobuf = require('protobufjs');

let Code =
{
    ChatMsg_C2S: -1,
    ChatMsg_S2C: -2,
    en_SubId_None: 0,
    en_Enter_Chat_Room_C2S: 1,
    en_Login_Chat_Room_C2S: 2,
    en_Send_Msg_C2S: 3,
    en_Query_Announcement_C2S: 4,
    en_Admin_Delete_Msg_C2S: 5,
    en_Enter_Chat_Room_Succ_S2C: 200,
    en_Login_Chat_Room_Succ_S2C: 201,
    en_Send_Last50_Msg_S2C: 202,
    en_Send_Announcement_Top_S2C: 203,
    en_Send_Msg_S2C: 204,
    en_Announcement_All_S2C: 205,
    en_Set_User_Be_Banned_S2C: 206,
    en_Admin_Delete_Msg_S2C: 207,
    en_Chat_Room_Common_S2C: 300,
    en_Heart_Beat_Ping_C2S: 1000,
    en_Heart_Beat_Pong_S2C: 1001,

}

let Type = {
    [Code.ChatMsg_C2S]: 'ChatMsg_C2S',
    [Code.ChatMsg_S2C]: 'ChatMsg_S2C',
    [Code.en_Enter_Chat_Room_C2S]: 'EnterRoom_C2S',
    [Code.en_Login_Chat_Room_C2S]: 'ChatRoomLogin_C2S',
    [Code.en_Send_Msg_C2S]: 'ChatRoomMessage_C2S',
    [Code.en_Admin_Delete_Msg_C2S]: 'DeleteChatRoomMessage_C2S',
    [Code.en_Enter_Chat_Room_Succ_S2C]: 'EnterRoom_S2C',
    [Code.en_Login_Chat_Room_Succ_S2C]: 'ChatRoomLoginSucc_S2C',
    [Code.en_Send_Last50_Msg_S2C]: 'ChatRoomMessageLast50_S2C',
    [Code.en_Send_Announcement_Top_S2C]: 'ChatRoomAnnouncement_S2C',
    [Code.en_Send_Msg_S2C]: 'ChatRoomMessage_S2C',
    [Code.en_Announcement_All_S2C]: 'ChatRoomAnnouncementAll_S2C',
    [Code.en_Set_User_Be_Banned_S2C]: 'ChatUserBeBanned_S2C',
    [Code.en_Admin_Delete_Msg_S2C]: 'DeleteChatRoomMessage_S2C',
    [Code.en_Chat_Room_Common_S2C]: 'ChatRoomCommonRes_S2C',
}


let langs = {
    "en": "EN",
    "cn": "ZH",
}

let clazz = {}

let path = '/static/proto/chat.proto';
let protobufRoot

function OncePromise(func) {
    let loading = false
    let callbacks = []
    let ok
    return async function (...params) {
        if (ok) return;
        return await new Promise(async r => {
            callbacks.push(r)
            if (loading) return;
            loading = true;
            ok = await func.call(this, ...params)
            loading = false;
            let data = callbacks;
            callbacks = []
            data.forEach(r => r())
        })
    }
}

function WaitPromise(func) {
    let loading = false
    let callbacks = []
    return async function (...params) {
        return await new Promise(async r => {
            callbacks.push(r)
            if (loading) return;
            loading = true;
            let result = await func.call(this, ...params)
            loading = false;
            let data = callbacks;
            callbacks = []
            data.forEach(r => r(result))
        })
    }
}

let Clazz = WaitPromise(async () => {
    if (protobufRoot) {
        return clazz;
    }
    let root = await new protobuf.Root().load(path, { keepCase: true })
    protobufRoot = root;
    Object.keys(Type).forEach(k => {
        if (Type[k]) {
            clazz[k] = root.lookupType(`ChatMsg.${Type[k]}`);
            console.log(clazz[k])
        }
    })
    return clazz;
})

let onMessage
let onTopAnnouncement
let onAnnouncements
let onChannel
let onUserdata

class Chat {

    ws
    language
    msgs = []
    enter
    login
    banned
    user_data
    onLogin
    onEnter
    timeout

    events = {
        [Code.en_Send_Announcement_Top_S2C](data) {
            onTopAnnouncement?.(data)
        },
        [Code.en_Announcement_All_S2C](data) {
            onAnnouncements?.(data.announcement || [])
        },
        [Code.en_Send_Msg_S2C](data) {
            this.msgs.push(data)
            onMessage?.(this.msgs)
        },
        [Code.en_Send_Last50_Msg_S2C](data) {
            this.msgs = data.message || [];
            onMessage?.(this.msgs)
        },
        [Code.en_Enter_Chat_Room_Succ_S2C](data) {
            console.error('====进入房间： ', data)
            this.enter = true;
            if (!onChannel) return;
            this.onEnter?.(true)
            Object.keys(langs).forEach(k => {
                if (data.language == langs[k]) {
                    onChannel?.(k)
                }
            })
        },
        [Code.en_Set_User_Be_Banned](data) {
            this.banned = data.banned
            console.error('====user banned: ', this.banned)
        },
        [Code.en_Login_Chat_Room_Succ_S2C](data) {
            console.error('====登录： ', data)
            this.login = true
            this.banned = data.banned
            this.user_data = data;
            this.onLogin?.(true)
            onUserdata?.({ ...this.user_data })
        },
        [Code.en_Heart_Beat_Pong_S2C](data) {
            this.checkTimeout()
        },
        [Code.en_Admin_Delete_Msg_S2C](data) {
            for (let index = 0; index < this.msgs.length; index++) {
                const m = this.msgs[index];
                if (m.message_id == data.message_id) {
                    this.msgs.splice(index, 1);
                    onMessage?.(this.msgs);
                    return;
                }
            }
        }
    }

    checkTimeout() {
        if (this.timeout) clearTimeout(this.timeout);
        this.timeout = setTimeout(() => {
            this.close();
        }, 30000);
    }

    open = WaitPromise(async () => {
        console.log(`ws-1`)
        if (this.ws) return;
        console.log(`ws-2`)
        return new Promise((r, j) => {
            let state = 0
            let lws = new WebSocket("wss://www.iszhk.com:8099/");

            lws.binaryType = "arraybuffer";


            lws.onopen = () => {
                state = 1
                console.log("====连接成功！", lws);
                this.ws = lws;
                r()
                this.checkTimeout()
                this.ping()
            };

            lws.onmessage = (event) => {
                console.log("====收到消息: ", event.data);
                this.deserializeMessage(event.data)
            };

            lws.onclose = () => {
                state = -1
                console.log("====连接关闭");
                this.ws = null;
            };

            lws.onerror = (error) => {
                console.error("====WebSocket 错误: ", error);
                this.ws = null;
                if (!state) j()
            };
        })
    })

    enterRoom = OncePromise(async language => {
        if (!language) {
            language = this.language
        } else {
            this.language = language
        }
        console.error('====发送进入房间：', language)
        this.sendMessage({ language: langs[language] || language }, Code.en_Enter_Chat_Room_C2S)
        return new Promise(r => this.onEnter = r)
    })

    loginRoom = OncePromise(async (token = uni.getStorageSync('token')) => {
        if (!token) return;
        if (this.login) return;
        console.error('====发送登录：', token)
        this.sendMessage({ token }, Code.en_Login_Chat_Room_C2S)
        return new Promise(r => this.onLogin = r)
    })

    getAnnouncementAll = WaitPromise(async () => {
        await this.enterRoom();
        await this.loginRoom();
        await this.sendMessage({}, Code.en_Query_Announcement_C2S)
        return await new Promise(r => onAnnouncements = r);
    })

    constructor() {
        onTopAnnouncement?.({})
        onMessage?.([])
    }

    ping() {
        if (!this.ws) return;
        this.sendMessage({}, Code.en_Heart_Beat_Ping_C2S);
        setTimeout(() => this.ping(), 10000);
    }

    async close() {
        console.log(`ws-3`)
        if (this.ws) this.ws.close();
    }

    async sendMsg(content) {
        if (this.banned) return 'banned';
        await this.enterRoom();
        await this.loginRoom();
        if (!this.login) return;
        await this.sendMessage({ content }, Code.en_Send_Msg_C2S)
    }

    async sendMessage(msg, sub_id) {
        try {
            await this.open()
            console.log('编码消息： ', sub_id, msg)
            let buffer = await this.Serialization({ main_id: 1, sub_id, params: await this.Serialization(msg, sub_id) }, Code.ChatMsg_C2S);
            console.log('发送消息： ', sub_id, buffer)
            this.ws.send(buffer);
        } catch (e) { throw e }
    }

    async Serialization(msg, sub_id) {
        if (!Type[sub_id]) return undefined;
        const Message = (await Clazz())[sub_id];
        const message = Message.create(msg);
        return Message.encode(message).finish();
    }

    async Deserialization(binaryData, sub_id) {
        if (!Type[sub_id]) return undefined;
        const Message = (await Clazz())[sub_id];
        const decodedMessage = Message.decode(new Uint8Array(binaryData));
        const obj = Message.toObject(decodedMessage, { default: true, keepCase: true });;
        return obj
    }

    async deserializeMessage(binaryData) {
        const message = await this.Deserialization(binaryData, Code.ChatMsg_S2C)
        const data = await this.Deserialization(message.params, message.sub_id)
        console.log('收到消息： ', message.sub_id, data)
        this.events[message.sub_id]?.call(this, data);
        return data;
    }

    async delMsg(message_id) {
        if (!this.user_data.isAdmin) return;
        await this.sendMessage({ message_id }, Code.en_Admin_Delete_Msg_C2S);
    }
}
let Instance

module.exports = {
    async enterRoom(language) {
        Instance?.close();
        Instance = new Chat()
        await Instance.enterRoom(language)
        await Instance.loginRoom()
    },
    async sendMessage(content) {
        return await Instance.sendMsg(content)
    },
    onMessage(callback) {
        onMessage = callback
    },
    onTopAnnouncement(callback) {
        onTopAnnouncement = callback
    },
    onChannel(callback) {
        onChannel = callback
    },
    getAnnouncementAll() {
        return Instance.getAnnouncementAll();
    },
    onUserdata(callback) {
        onUserdata = callback;
    },
    delMsg(id) {
        Instance.delMsg(id);
    }
};