import Vue from 'vue'
import Vuex from 'vuex'
import { decode } from 'blurhash'

// vuex 和持久化储存 vuex-persistedstate
// import createPersistedState from 'vuex-persistedstate'
Vue.use(Vuex)

//Vuex 的核心概念
//1、state 存储共享数据
//2、actions 接收组件发过来的请求（中转站）
//3、mutations 接受actions发过来的请求，对状态进行处理。
//4、getters 修改过后的状态
//5、modules 对不同的状态进行分类

import themes from './theme.js'
const store = new Vuex.Store({
	// plugins: [createPersistedState({
	// 	storage: window.localStorage, // 或者 sessionStorage
	// })],
	state: {
		currentTheme: "defaultTheme",
		themes: themes,
		url: '', //地址
		max: 0, //总时长
		schedule: 0, //进度
		list: [], //目录
		music: uni.createInnerAudioContext(), //创建播放器对象
		is_bf: false, //当前播放状态
		index: 0, //索引
		onLineUsers: { events: new Map(), data: {} },
		resDomainUrl: '',//资源服务器地址
		blurhashTemp: { data: {} },
		pageName: '99',
	},
	actions: {

	},
	modules: {

	},
	getters: {
		theme(state) {
			return state.themes[state.currentTheme].style
		},
		currentTheme: state => state.currentTheme,
		resDomainUrl: state => state.resDomainUrl,
		pageName: state => state.pageName
	},
	mutations: {
		changeTheme(state, themeName = "defaultTheme") {
			state.currentTheme = themeName
			// 保存当前主题到本地存储
			uni.setStorageSync('currentTheme', themeName);
		},

		//设置播放列表
		setList(state, list) {
			state.list = list;
			//////console.log(state, list)
		},
		//设置播放路径
		setMusicUrl(state, index) {
			//////console.log(index)
			//设置索引
			state.index = index;
			//设置路径
			state.url = state.list[index].url;
			//播放器引入url
			state.music.src = state.list[index].url;
			//初始化播放进度
			state.music.startTime = 0;
			//开始播放
			state.music.play(); //执行播放
			//设置播放状态
			state.is_bf = true;
			//获取播放进度
			state.music.onTimeUpdate(() => {
				//设置总时长
				state.max = state.music.duration;
				//修改进度
				state.schedule = state.music.currentTime;
			})
		},
		//修改播放进度
		setSchedule(state, num) {
			state.schedule = state.max * num;
			state.music.currentTime = state.schedule;
		},
		//开始播放音频
		play(state, num) {
			state.is_bf = true;
			state.music.play();
		},
		//暂停当前播放的音频
		pause(state, num) {
			state.is_bf = false;
			state.music.pause();
		},
		RegOnlineUsers(state, { callback, target }) {
			state.onLineUsers.events.set(callback, target);
			if (state.onLineUsers.doing > Date.now()) return callback.call(target, state.onLineUsers.data);
			state.onLineUsers.doing = Date.now() + 10000;
			console.log('request ----- ')
			Vue.prototype.$u.post('/stat/online', {}).then(res => {
				console.log('request ----- res', res)
				if (res.code == 0) {
					state.onLineUsers.data = res.data;
					state.onLineUsers.events.forEach((v, k) => k.call(v, res.data))
				} else {
					state.onLineUsers.doing = 0
				}
			})
		},
		unregOnlineUsers(state, { callback, target }) {
			state.onLineUsers.events.delete(callback);
		},
		//设置资源服务器域名
		setResDomianUrl(state, url) {
			state.resDomainUrl = url;
		},
		GetUrlFromBlurhash(state, data) {
			if (!state.blurhashTemp.parse) state.blurhashTemp.parse = (() => {
				const width = 24;
				const height = 32;
				const canvas = document.createElement('canvas');
				const context = canvas.getContext('2d');
				canvas.width = width;
				canvas.height = height;
				const imageData = context.createImageData(width, height);
				let tt = { all: 0, frame: 0, cache: {}, temp: [] }
				let parse = ({ hash, callback }) => {
					imageData.data.set(decode(hash, width, height));
					context.putImageData(imageData, 0, 0);
					const dataURL = canvas.toDataURL();
					tt.cache[hash] = dataURL;
					callback(dataURL);
				}
				let func = data => {
					if (tt.cache[data.hash]) return data.callback(tt.cache[data.hash]);
					if (!tt.nextTick) {
						tt.nextTick = true
						setTimeout(() => {
							tt.nextTick = false;
							tt.frame = 0;
							tt.cache = {}
							let temp = tt.temp;
							tt.temp = [];
							temp.forEach(func)
						}, 0);
					}
					if (tt.frame >= 24) {
						tt.temp.push(data)
						return;
					}
					tt.frame++;
					parse(data)
				}
				return func;
			})();
			state.blurhashTemp.parse(data)
		},
		setPageName(state, name) {
			state.pageName = name.toString();
		}
	}
})
export default store